@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ExecutionTriggerArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.TriggerType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Execution trigger for storage task assignment
 * @property parameters The trigger parameters of the storage task assignment execution
 * @property type The trigger type of the storage task assignment execution
 */
public data class ExecutionTriggerArgs(
    public val parameters: Output<TriggerParametersArgs>,
    public val type: Output<TriggerType>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ExecutionTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ExecutionTriggerArgs =
        com.pulumi.azurenative.storage.inputs.ExecutionTriggerArgs.builder()
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ExecutionTriggerArgs].
 */
@PulumiTagMarker
public class ExecutionTriggerArgsBuilder internal constructor() {
    private var parameters: Output<TriggerParametersArgs>? = null

    private var type: Output<TriggerType>? = null

    /**
     * @param value The trigger parameters of the storage task assignment execution
     */
    @JvmName("jbrkgpllxowclqjt")
    public suspend fun parameters(`value`: Output<TriggerParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The trigger type of the storage task assignment execution
     */
    @JvmName("pjicwyquxqgqfbdt")
    public suspend fun type(`value`: Output<TriggerType>) {
        this.type = value
    }

    /**
     * @param value The trigger parameters of the storage task assignment execution
     */
    @JvmName("dahbihjeaxsnoihp")
    public suspend fun parameters(`value`: TriggerParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The trigger parameters of the storage task assignment execution
     */
    @JvmName("ddyermssocnicnxg")
    public suspend fun parameters(argument: suspend TriggerParametersArgsBuilder.() -> Unit) {
        val toBeMapped = TriggerParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value The trigger type of the storage task assignment execution
     */
    @JvmName("scjxvrrunsxmwnwn")
    public suspend fun type(`value`: TriggerType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ExecutionTriggerArgs = ExecutionTriggerArgs(
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
