@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.GetStorageTaskAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageTaskAssignmentName The name of the storage task assignment within the specified resource group. Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 */
public data class GetStorageTaskAssignmentPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val storageTaskAssignmentName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.GetStorageTaskAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.GetStorageTaskAssignmentPlainArgs =
        com.pulumi.azurenative.storage.inputs.GetStorageTaskAssignmentPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageTaskAssignmentName(storageTaskAssignmentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStorageTaskAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetStorageTaskAssignmentPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var storageTaskAssignmentName: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("chcmousboaebbwvs")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sqyqngwxmuwkxqnn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the storage task assignment within the specified resource group. Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("gaoueltlydmytduw")
    public suspend fun storageTaskAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageTaskAssignmentName = mapped
    }

    internal fun build(): GetStorageTaskAssignmentPlainArgs = GetStorageTaskAssignmentPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageTaskAssignmentName = storageTaskAssignmentName ?: throw
            PulumiNullFieldException("storageTaskAssignmentName"),
    )
}
