@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.GetTableServicePropertiesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property tableServiceName The name of the Table Service within the specified storage account. Table Service Name must be 'default'
 */
public data class GetTableServicePropertiesPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val tableServiceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.GetTableServicePropertiesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.GetTableServicePropertiesPlainArgs =
        com.pulumi.azurenative.storage.inputs.GetTableServicePropertiesPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .tableServiceName(tableServiceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTableServicePropertiesPlainArgs].
 */
@PulumiTagMarker
public class GetTableServicePropertiesPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var tableServiceName: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("vwbkpuafmdjwpcca")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("vuqmfnmrgempsekd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Table Service within the specified storage account. Table Service Name must be 'default'
     */
    @JvmName("fxjyrurwaudjitwl")
    public suspend fun tableServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tableServiceName = mapped
    }

    internal fun build(): GetTableServicePropertiesPlainArgs = GetTableServicePropertiesPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        tableServiceName = tableServiceName ?: throw PulumiNullFieldException("tableServiceName"),
    )
}
