@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ImmutableStorageWithVersioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Object level immutability properties of the container.
 * @property enabled This is an immutable property, when set to true it enables object level immutability at the container level.
 */
public data class ImmutableStorageWithVersioningArgs(
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ImmutableStorageWithVersioningArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ImmutableStorageWithVersioningArgs =
        com.pulumi.azurenative.storage.inputs.ImmutableStorageWithVersioningArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImmutableStorageWithVersioningArgs].
 */
@PulumiTagMarker
public class ImmutableStorageWithVersioningArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value This is an immutable property, when set to true it enables object level immutability at the container level.
     */
    @JvmName("nmwcokorcdhoaqyp")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value This is an immutable property, when set to true it enables object level immutability at the container level.
     */
    @JvmName("ncodfffgqqlbowgr")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ImmutableStorageWithVersioningArgs = ImmutableStorageWithVersioningArgs(
        enabled = enabled,
    )
}
