@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of key vault.
 * @property keyName The name of KeyVault key.
 * @property keyVaultUri The Uri of KeyVault.
 * @property keyVersion The version of KeyVault key.
 */
public data class KeyVaultPropertiesArgs(
    public val keyName: Output<String>? = null,
    public val keyVaultUri: Output<String>? = null,
    public val keyVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.KeyVaultPropertiesArgs =
        com.pulumi.azurenative.storage.inputs.KeyVaultPropertiesArgs.builder()
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri?.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultPropertiesArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    private var keyVersion: Output<String>? = null

    /**
     * @param value The name of KeyVault key.
     */
    @JvmName("llovssyostfjdjip")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The Uri of KeyVault.
     */
    @JvmName("axwjrbpwouitogwv")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The version of KeyVault key.
     */
    @JvmName("dgnwyrphqmjjuhvv")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value The name of KeyVault key.
     */
    @JvmName("afcvxpkfibwrimpq")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The Uri of KeyVault.
     */
    @JvmName("aqlunqnmgeygbdhp")
    public suspend fun keyVaultUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value The version of KeyVault key.
     */
    @JvmName("pxruvhquwtvclgem")
    public suspend fun keyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    internal fun build(): KeyVaultPropertiesArgs = KeyVaultPropertiesArgs(
        keyName = keyName,
        keyVaultUri = keyVaultUri,
        keyVersion = keyVersion,
    )
}
