@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ListStorageAccountSASPlainArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.HttpProtocol
import com.pulumi.azurenative.storage.kotlin.enums.Permissions
import com.pulumi.azurenative.storage.kotlin.enums.Services
import com.pulumi.azurenative.storage.kotlin.enums.SignedResourceTypes
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property iPAddressOrRange An IP address or a range of IP addresses from which to accept requests.
 * @property keyToSign The key to sign the account SAS token with.
 * @property permissions The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
 * @property protocols The protocol permitted for a request made with the account SAS.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property resourceTypes The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
 * @property services The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f).
 * @property sharedAccessExpiryTime The time at which the shared access signature becomes invalid.
 * @property sharedAccessStartTime The time at which the SAS becomes valid.
 */
public data class ListStorageAccountSASPlainArgs(
    public val accountName: String,
    public val iPAddressOrRange: String? = null,
    public val keyToSign: String? = null,
    public val permissions: Either<String, Permissions>,
    public val protocols: HttpProtocol? = null,
    public val resourceGroupName: String,
    public val resourceTypes: Either<String, SignedResourceTypes>,
    public val services: Either<String, Services>,
    public val sharedAccessExpiryTime: String,
    public val sharedAccessStartTime: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ListStorageAccountSASPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ListStorageAccountSASPlainArgs =
        com.pulumi.azurenative.storage.inputs.ListStorageAccountSASPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .iPAddressOrRange(iPAddressOrRange?.let({ args0 -> args0 }))
            .keyToSign(keyToSign?.let({ args0 -> args0 }))
            .permissions(
                permissions.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .protocols(protocols?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceTypes(
                resourceTypes.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .services(
                services.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sharedAccessExpiryTime(sharedAccessExpiryTime.let({ args0 -> args0 }))
            .sharedAccessStartTime(sharedAccessStartTime?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListStorageAccountSASPlainArgs].
 */
@PulumiTagMarker
public class ListStorageAccountSASPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var iPAddressOrRange: String? = null

    private var keyToSign: String? = null

    private var permissions: Either<String, Permissions>? = null

    private var protocols: HttpProtocol? = null

    private var resourceGroupName: String? = null

    private var resourceTypes: Either<String, SignedResourceTypes>? = null

    private var services: Either<String, Services>? = null

    private var sharedAccessExpiryTime: String? = null

    private var sharedAccessStartTime: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("wuqroqtlfkluvjrn")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value An IP address or a range of IP addresses from which to accept requests.
     */
    @JvmName("exdvkvsxmdpyslhg")
    public suspend fun iPAddressOrRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.iPAddressOrRange = mapped
    }

    /**
     * @param value The key to sign the account SAS token with.
     */
    @JvmName("rlcufagliuqajxcs")
    public suspend fun keyToSign(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyToSign = mapped
    }

    /**
     * @param value The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
     */
    @JvmName("ydpidhgpjqkoficp")
    public suspend fun permissions(`value`: Either<String, Permissions>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.permissions = mapped
    }

    /**
     * @param value The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
     */
    @JvmName("kvbubveqcuxqqcju")
    public fun permissions(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Permissions>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.permissions = mapped
    }

    /**
     * @param value The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
     */
    @JvmName("ybmnixlnigidkuoj")
    public fun permissions(`value`: Permissions) {
        val toBeMapped = Either.ofRight<String, Permissions>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.permissions = mapped
    }

    /**
     * @param value The protocol permitted for a request made with the account SAS.
     */
    @JvmName("dqjewelsrxonvltq")
    public suspend fun protocols(`value`: HttpProtocol?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.protocols = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("vpmctvyfopireqsf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
     */
    @JvmName("nhxxoyygqfcjtekt")
    public suspend fun resourceTypes(`value`: Either<String, SignedResourceTypes>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceTypes = mapped
    }

    /**
     * @param value The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
     */
    @JvmName("tyfwocjsryfdfaxq")
    public fun resourceTypes(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SignedResourceTypes>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceTypes = mapped
    }

    /**
     * @param value The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
     */
    @JvmName("oeeknnfwpvsevnwq")
    public fun resourceTypes(`value`: SignedResourceTypes) {
        val toBeMapped = Either.ofRight<String, SignedResourceTypes>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceTypes = mapped
    }

    /**
     * @param value The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f).
     */
    @JvmName("hblpclsxjpakrsac")
    public suspend fun services(`value`: Either<String, Services>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.services = mapped
    }

    /**
     * @param value The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f).
     */
    @JvmName("olyvogpjguviqlen")
    public fun services(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Services>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.services = mapped
    }

    /**
     * @param value The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f).
     */
    @JvmName("sstvwwotxkhshocm")
    public fun services(`value`: Services) {
        val toBeMapped = Either.ofRight<String, Services>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.services = mapped
    }

    /**
     * @param value The time at which the shared access signature becomes invalid.
     */
    @JvmName("ytgdtmmhdintggjn")
    public suspend fun sharedAccessExpiryTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sharedAccessExpiryTime = mapped
    }

    /**
     * @param value The time at which the SAS becomes valid.
     */
    @JvmName("jiykbwfcqcxaqvdu")
    public suspend fun sharedAccessStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sharedAccessStartTime = mapped
    }

    internal fun build(): ListStorageAccountSASPlainArgs = ListStorageAccountSASPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        iPAddressOrRange = iPAddressOrRange,
        keyToSign = keyToSign,
        permissions = permissions ?: throw PulumiNullFieldException("permissions"),
        protocols = protocols,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceTypes = resourceTypes ?: throw PulumiNullFieldException("resourceTypes"),
        services = services ?: throw PulumiNullFieldException("services"),
        sharedAccessExpiryTime = sharedAccessExpiryTime ?: throw
            PulumiNullFieldException("sharedAccessExpiryTime"),
        sharedAccessStartTime = sharedAccessStartTime,
    )
}
