@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ManagementPolicySchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
 * @property rules The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
 */
public data class ManagementPolicySchemaArgs(
    public val rules: Output<List<ManagementPolicyRuleArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ManagementPolicySchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ManagementPolicySchemaArgs =
        com.pulumi.azurenative.storage.inputs.ManagementPolicySchemaArgs.builder()
            .rules(
                rules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagementPolicySchemaArgs].
 */
@PulumiTagMarker
public class ManagementPolicySchemaArgsBuilder internal constructor() {
    private var rules: Output<List<ManagementPolicyRuleArgs>>? = null

    /**
     * @param value The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    @JvmName("wvcqofenuslofelm")
    public suspend fun rules(`value`: Output<List<ManagementPolicyRuleArgs>>) {
        this.rules = value
    }

    @JvmName("kdavqdramgqulyat")
    public suspend fun rules(vararg values: Output<ManagementPolicyRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    @JvmName("wgsdbccbscowdnoi")
    public suspend fun rules(values: List<Output<ManagementPolicyRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    @JvmName("mqycpyocdixcgind")
    public suspend fun rules(`value`: List<ManagementPolicyRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    @JvmName("eittphsvxwrwkwmt")
    public suspend fun rules(argument: List<suspend ManagementPolicyRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagementPolicyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    @JvmName("yoywiywrbvnjkxep")
    public suspend fun rules(vararg argument: suspend ManagementPolicyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagementPolicyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    @JvmName("manrplpqjkkfcfpk")
    public suspend fun rules(argument: suspend ManagementPolicyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ManagementPolicyRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    @JvmName("bqybvpnbkgdhcqcx")
    public suspend fun rules(vararg values: ManagementPolicyRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): ManagementPolicySchemaArgs = ManagementPolicySchemaArgs(
        rules = rules ?: throw PulumiNullFieldException("rules"),
    )
}
