@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The replication policy rule between two containers.
 * @property destinationContainer Required. Destination container name.
 * @property filters Optional. An object that defines the filter set.
 * @property ruleId Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account.
 * @property sourceContainer Required. Source container name.
 */
public data class ObjectReplicationPolicyRuleArgs(
    public val destinationContainer: Output<String>,
    public val filters: Output<ObjectReplicationPolicyFilterArgs>? = null,
    public val ruleId: Output<String>? = null,
    public val sourceContainer: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyRuleArgs =
        com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyRuleArgs.builder()
            .destinationContainer(destinationContainer.applyValue({ args0 -> args0 }))
            .filters(filters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .sourceContainer(sourceContainer.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ObjectReplicationPolicyRuleArgs].
 */
@PulumiTagMarker
public class ObjectReplicationPolicyRuleArgsBuilder internal constructor() {
    private var destinationContainer: Output<String>? = null

    private var filters: Output<ObjectReplicationPolicyFilterArgs>? = null

    private var ruleId: Output<String>? = null

    private var sourceContainer: Output<String>? = null

    /**
     * @param value Required. Destination container name.
     */
    @JvmName("ijakdkuugtknexjr")
    public suspend fun destinationContainer(`value`: Output<String>) {
        this.destinationContainer = value
    }

    /**
     * @param value Optional. An object that defines the filter set.
     */
    @JvmName("yfbohlwaaynqhwfk")
    public suspend fun filters(`value`: Output<ObjectReplicationPolicyFilterArgs>) {
        this.filters = value
    }

    /**
     * @param value Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account.
     */
    @JvmName("imykvqalpmdssrby")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value Required. Source container name.
     */
    @JvmName("bgeglfvctkeinnpp")
    public suspend fun sourceContainer(`value`: Output<String>) {
        this.sourceContainer = value
    }

    /**
     * @param value Required. Destination container name.
     */
    @JvmName("mvnoyvqwmmvqnbfm")
    public suspend fun destinationContainer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationContainer = mapped
    }

    /**
     * @param value Optional. An object that defines the filter set.
     */
    @JvmName("uxbimjqfarloiclg")
    public suspend fun filters(`value`: ObjectReplicationPolicyFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument Optional. An object that defines the filter set.
     */
    @JvmName("gysfkvxbhketqasn")
    public suspend fun filters(argument: suspend ObjectReplicationPolicyFilterArgsBuilder.() -> Unit) {
        val toBeMapped = ObjectReplicationPolicyFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param value Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account.
     */
    @JvmName("iedorpekfmiiphfk")
    public suspend fun ruleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value Required. Source container name.
     */
    @JvmName("vqfhceuukfochmqo")
    public suspend fun sourceContainer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceContainer = mapped
    }

    internal fun build(): ObjectReplicationPolicyRuleArgs = ObjectReplicationPolicyRuleArgs(
        destinationContainer = destinationContainer ?: throw
            PulumiNullFieldException("destinationContainer"),
        filters = filters,
        ruleId = ruleId,
        sourceContainer = sourceContainer ?: throw PulumiNullFieldException("sourceContainer"),
    )
}
