@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.PrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.PrivateEndpointServiceConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of information about the state of the connection between service consumer and provider.
 * @property actionRequired A message indicating if changes on the service provider require any updates on the consumer.
 * @property description The reason for approval/rejection of the connection.
 * @property status Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
 */
public data class PrivateLinkServiceConnectionStateArgs(
    public val actionRequired: Output<String>? = null,
    public val description: Output<String>? = null,
    public val status: Output<Either<String, PrivateEndpointServiceConnectionStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.PrivateLinkServiceConnectionStateArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.PrivateLinkServiceConnectionStateArgs = com.pulumi.azurenative.storage.inputs.PrivateLinkServiceConnectionStateArgs.builder()
        .actionRequired(actionRequired?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .status(
            status?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        ).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var actionRequired: Output<String>? = null

    private var description: Output<String>? = null

    private var status: Output<Either<String, PrivateEndpointServiceConnectionStatus>>? = null

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("buwcxadbnvdhlqoe")
    public suspend fun actionRequired(`value`: Output<String>) {
        this.actionRequired = value
    }

    /**
     * @param value The reason for approval/rejection of the connection.
     */
    @JvmName("pbwflvauvehvkqfk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("puqwxgtpueccacky")
    public suspend fun status(`value`: Output<Either<String, PrivateEndpointServiceConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("lftbnsfpuvbgycyf")
    public suspend fun actionRequired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionRequired = mapped
    }

    /**
     * @param value The reason for approval/rejection of the connection.
     */
    @JvmName("ojffvkyylsqtwwcr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("dwvcrfcaqdsbdfkw")
    public suspend fun status(`value`: Either<String, PrivateEndpointServiceConnectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("enqubnbdsupldhrh")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateEndpointServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("netlcfauwawyhtea")
    public fun status(`value`: PrivateEndpointServiceConnectionStatus) {
        val toBeMapped = Either.ofRight<String, PrivateEndpointServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStateArgs =
        PrivateLinkServiceConnectionStateArgs(
            actionRequired = actionRequired,
            description = description,
            status = status,
        )
}
