@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.RestorePolicyPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The blob service properties for blob restore policy
 * @property days how long this blob can be restored. It should be great than zero and less than DeleteRetentionPolicy.days.
 * @property enabled Blob restore is enabled if set to true.
 */
public data class RestorePolicyPropertiesArgs(
    public val days: Output<Int>? = null,
    public val enabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.RestorePolicyPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.RestorePolicyPropertiesArgs =
        com.pulumi.azurenative.storage.inputs.RestorePolicyPropertiesArgs.builder()
            .days(days?.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestorePolicyPropertiesArgs].
 */
@PulumiTagMarker
public class RestorePolicyPropertiesArgsBuilder internal constructor() {
    private var days: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value how long this blob can be restored. It should be great than zero and less than DeleteRetentionPolicy.days.
     */
    @JvmName("dcodhgyxfjigkcdh")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Blob restore is enabled if set to true.
     */
    @JvmName("gagvhowpwvocaofp")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value how long this blob can be restored. It should be great than zero and less than DeleteRetentionPolicy.days.
     */
    @JvmName("lgeqkgegtiqunvpc")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value Blob restore is enabled if set to true.
     */
    @JvmName("opelhsejayjbylii")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): RestorePolicyPropertiesArgs = RestorePolicyPropertiesArgs(
        days = days,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
    )
}
