@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentExecutionContextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Execution context of the storage task assignment.
 * @property target Execution target of the storage task assignment
 * @property trigger Execution trigger of the storage task assignment
 */
public data class StorageTaskAssignmentExecutionContextArgs(
    public val target: Output<ExecutionTargetArgs>,
    public val trigger: Output<ExecutionTriggerArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentExecutionContextArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentExecutionContextArgs =
        com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentExecutionContextArgs.builder()
            .target(target.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trigger(trigger.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [StorageTaskAssignmentExecutionContextArgs].
 */
@PulumiTagMarker
public class StorageTaskAssignmentExecutionContextArgsBuilder internal constructor() {
    private var target: Output<ExecutionTargetArgs>? = null

    private var trigger: Output<ExecutionTriggerArgs>? = null

    /**
     * @param value Execution target of the storage task assignment
     */
    @JvmName("gcgnrhjdsbulguei")
    public suspend fun target(`value`: Output<ExecutionTargetArgs>) {
        this.target = value
    }

    /**
     * @param value Execution trigger of the storage task assignment
     */
    @JvmName("wtobxklcpecxynpc")
    public suspend fun trigger(`value`: Output<ExecutionTriggerArgs>) {
        this.trigger = value
    }

    /**
     * @param value Execution target of the storage task assignment
     */
    @JvmName("ullhkxaxtrdojtku")
    public suspend fun target(`value`: ExecutionTargetArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param argument Execution target of the storage task assignment
     */
    @JvmName("shbtdgfpqslislau")
    public suspend fun target(argument: suspend ExecutionTargetArgsBuilder.() -> Unit) {
        val toBeMapped = ExecutionTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.target = mapped
    }

    /**
     * @param value Execution trigger of the storage task assignment
     */
    @JvmName("pdfbearyjcwvkmwy")
    public suspend fun trigger(`value`: ExecutionTriggerArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trigger = mapped
    }

    /**
     * @param argument Execution trigger of the storage task assignment
     */
    @JvmName("wefhklcevorvxjxp")
    public suspend fun trigger(argument: suspend ExecutionTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = ExecutionTriggerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trigger = mapped
    }

    internal fun build(): StorageTaskAssignmentExecutionContextArgs =
        StorageTaskAssignmentExecutionContextArgs(
            target = target ?: throw PulumiNullFieldException("target"),
            trigger = trigger ?: throw PulumiNullFieldException("trigger"),
        )
}
