@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of the storage task assignment.
 * @property description Text that describes the purpose of the storage task assignment
 * @property enabled Whether the storage task assignment is enabled or not
 * @property executionContext The storage task assignment execution context
 * @property report The storage task assignment report
 * @property taskId Id of the corresponding storage task
 */
public data class StorageTaskAssignmentPropertiesArgs(
    public val description: Output<String>,
    public val enabled: Output<Boolean>,
    public val executionContext: Output<StorageTaskAssignmentExecutionContextArgs>,
    public val report: Output<StorageTaskAssignmentReportArgs>,
    public val taskId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentPropertiesArgs =
        com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentPropertiesArgs.builder()
            .description(description.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .executionContext(executionContext.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .report(report.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taskId(taskId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageTaskAssignmentPropertiesArgs].
 */
@PulumiTagMarker
public class StorageTaskAssignmentPropertiesArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var executionContext: Output<StorageTaskAssignmentExecutionContextArgs>? = null

    private var report: Output<StorageTaskAssignmentReportArgs>? = null

    private var taskId: Output<String>? = null

    /**
     * @param value Text that describes the purpose of the storage task assignment
     */
    @JvmName("dltyqbplxkgjgiwf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether the storage task assignment is enabled or not
     */
    @JvmName("ugcwqhbhduhpkfjr")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The storage task assignment execution context
     */
    @JvmName("evbpsjhpsictdloh")
    public suspend fun executionContext(`value`: Output<StorageTaskAssignmentExecutionContextArgs>) {
        this.executionContext = value
    }

    /**
     * @param value The storage task assignment report
     */
    @JvmName("cdugtihmoupssluj")
    public suspend fun report(`value`: Output<StorageTaskAssignmentReportArgs>) {
        this.report = value
    }

    /**
     * @param value Id of the corresponding storage task
     */
    @JvmName("icghvjxgiuyxkunp")
    public suspend fun taskId(`value`: Output<String>) {
        this.taskId = value
    }

    /**
     * @param value Text that describes the purpose of the storage task assignment
     */
    @JvmName("igvvxbqfdwxjokql")
    public suspend fun description(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether the storage task assignment is enabled or not
     */
    @JvmName("fauauksdodvprxos")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The storage task assignment execution context
     */
    @JvmName("vhsepcrundnbanwr")
    public suspend fun executionContext(`value`: StorageTaskAssignmentExecutionContextArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.executionContext = mapped
    }

    /**
     * @param argument The storage task assignment execution context
     */
    @JvmName("mcbwnvymplsgbgmm")
    public suspend fun executionContext(argument: suspend StorageTaskAssignmentExecutionContextArgsBuilder.() -> Unit) {
        val toBeMapped = StorageTaskAssignmentExecutionContextArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.executionContext = mapped
    }

    /**
     * @param value The storage task assignment report
     */
    @JvmName("lbpkcrpwfnmrcjxl")
    public suspend fun report(`value`: StorageTaskAssignmentReportArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.report = mapped
    }

    /**
     * @param argument The storage task assignment report
     */
    @JvmName("btvoauewiihwliso")
    public suspend fun report(argument: suspend StorageTaskAssignmentReportArgsBuilder.() -> Unit) {
        val toBeMapped = StorageTaskAssignmentReportArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.report = mapped
    }

    /**
     * @param value Id of the corresponding storage task
     */
    @JvmName("siwovjuxqbvvouny")
    public suspend fun taskId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskId = mapped
    }

    internal fun build(): StorageTaskAssignmentPropertiesArgs = StorageTaskAssignmentPropertiesArgs(
        description = description ?: throw PulumiNullFieldException("description"),
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        executionContext = executionContext ?: throw PulumiNullFieldException("executionContext"),
        report = report ?: throw PulumiNullFieldException("report"),
        taskId = taskId ?: throw PulumiNullFieldException("taskId"),
    )
}
