@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentReportArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The storage task assignment report
 * @property prefix The container prefix for the location of storage task assignment report
 */
public data class StorageTaskAssignmentReportArgs(
    public val prefix: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentReportArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentReportArgs =
        com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentReportArgs.builder()
            .prefix(prefix.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageTaskAssignmentReportArgs].
 */
@PulumiTagMarker
public class StorageTaskAssignmentReportArgsBuilder internal constructor() {
    private var prefix: Output<String>? = null

    /**
     * @param value The container prefix for the location of storage task assignment report
     */
    @JvmName("uysgcuxhubaygeho")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The container prefix for the location of storage task assignment report
     */
    @JvmName("upccwtfoisskpcjv")
    public suspend fun prefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): StorageTaskAssignmentReportArgs = StorageTaskAssignmentReportArgs(
        prefix = prefix ?: throw PulumiNullFieldException("prefix"),
    )
}
