@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.TableAccessPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Table Access Policy Properties Object.
 * @property expiryTime Expiry time of the access policy
 * @property permission Required. List of abbreviated permissions. Supported permission values include 'r','a','u','d'
 * @property startTime Start time of the access policy
 */
public data class TableAccessPolicyArgs(
    public val expiryTime: Output<String>? = null,
    public val permission: Output<String>,
    public val startTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.TableAccessPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.TableAccessPolicyArgs =
        com.pulumi.azurenative.storage.inputs.TableAccessPolicyArgs.builder()
            .expiryTime(expiryTime?.applyValue({ args0 -> args0 }))
            .permission(permission.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableAccessPolicyArgs].
 */
@PulumiTagMarker
public class TableAccessPolicyArgsBuilder internal constructor() {
    private var expiryTime: Output<String>? = null

    private var permission: Output<String>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value Expiry time of the access policy
     */
    @JvmName("cwefonahvfkyvjwm")
    public suspend fun expiryTime(`value`: Output<String>) {
        this.expiryTime = value
    }

    /**
     * @param value Required. List of abbreviated permissions. Supported permission values include 'r','a','u','d'
     */
    @JvmName("kotlxjbrhdopbilj")
    public suspend fun permission(`value`: Output<String>) {
        this.permission = value
    }

    /**
     * @param value Start time of the access policy
     */
    @JvmName("nqdvjiohqqwedrcb")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Expiry time of the access policy
     */
    @JvmName("mqkkaxxwpcctgsan")
    public suspend fun expiryTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiryTime = mapped
    }

    /**
     * @param value Required. List of abbreviated permissions. Supported permission values include 'r','a','u','d'
     */
    @JvmName("mnweuogdfxqgaurt")
    public suspend fun permission(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permission = mapped
    }

    /**
     * @param value Start time of the access policy
     */
    @JvmName("globoedkwffqivrb")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): TableAccessPolicyArgs = TableAccessPolicyArgs(
        expiryTime = expiryTime,
        permission = permission ?: throw PulumiNullFieldException("permission"),
        startTime = startTime,
    )
}
