@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.TriggerParametersArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.IntervalUnit
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The trigger parameters update for the storage task assignment execution
 * @property endBy When to end task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
 * @property interval Run interval of task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
 * @property intervalUnit Run interval unit of task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
 * @property startFrom When to start task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
 * @property startOn When to start task execution. This is an optional field when ExecutionTrigger.properties.type is 'RunOnce'; this property should not be present when ExecutionTrigger.properties.type is 'OnSchedule'
 */
public data class TriggerParametersArgs(
    public val endBy: Output<String>? = null,
    public val interval: Output<Int>? = null,
    public val intervalUnit: Output<IntervalUnit>? = null,
    public val startFrom: Output<String>? = null,
    public val startOn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.TriggerParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.TriggerParametersArgs =
        com.pulumi.azurenative.storage.inputs.TriggerParametersArgs.builder()
            .endBy(endBy?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .intervalUnit(intervalUnit?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startFrom(startFrom?.applyValue({ args0 -> args0 }))
            .startOn(startOn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TriggerParametersArgs].
 */
@PulumiTagMarker
public class TriggerParametersArgsBuilder internal constructor() {
    private var endBy: Output<String>? = null

    private var interval: Output<Int>? = null

    private var intervalUnit: Output<IntervalUnit>? = null

    private var startFrom: Output<String>? = null

    private var startOn: Output<String>? = null

    /**
     * @param value When to end task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
     */
    @JvmName("rtefchflpnnowrhf")
    public suspend fun endBy(`value`: Output<String>) {
        this.endBy = value
    }

    /**
     * @param value Run interval of task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
     */
    @JvmName("lhlmdwybdeowlnoy")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value Run interval unit of task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
     */
    @JvmName("tfexbgtyjqgryqfr")
    public suspend fun intervalUnit(`value`: Output<IntervalUnit>) {
        this.intervalUnit = value
    }

    /**
     * @param value When to start task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
     */
    @JvmName("qvpbjtjgxssfmcdh")
    public suspend fun startFrom(`value`: Output<String>) {
        this.startFrom = value
    }

    /**
     * @param value When to start task execution. This is an optional field when ExecutionTrigger.properties.type is 'RunOnce'; this property should not be present when ExecutionTrigger.properties.type is 'OnSchedule'
     */
    @JvmName("txfgyvorbkyriwed")
    public suspend fun startOn(`value`: Output<String>) {
        this.startOn = value
    }

    /**
     * @param value When to end task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
     */
    @JvmName("laukupbermifosqn")
    public suspend fun endBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endBy = mapped
    }

    /**
     * @param value Run interval of task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
     */
    @JvmName("efxuhsqpphmuochm")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value Run interval unit of task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
     */
    @JvmName("qgbpcpurhmnmwmwg")
    public suspend fun intervalUnit(`value`: IntervalUnit?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intervalUnit = mapped
    }

    /**
     * @param value When to start task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
     */
    @JvmName("psktwvrvpwkqydir")
    public suspend fun startFrom(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startFrom = mapped
    }

    /**
     * @param value When to start task execution. This is an optional field when ExecutionTrigger.properties.type is 'RunOnce'; this property should not be present when ExecutionTrigger.properties.type is 'OnSchedule'
     */
    @JvmName("wuwwdtigqprogcno")
    public suspend fun startOn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startOn = mapped
    }

    internal fun build(): TriggerParametersArgs = TriggerParametersArgs(
        endBy = endBy,
        interval = interval,
        intervalUnit = intervalUnit,
        startFrom = startFrom,
        startOn = startOn,
    )
}
