@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property expiryTime Expiry time of the access policy
 * @property permission List of abbreviated permissions.
 * @property startTime Start time of the access policy
 */
public data class AccessPolicyResponse(
    public val expiryTime: String? = null,
    public val permission: String? = null,
    public val startTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.AccessPolicyResponse): AccessPolicyResponse = AccessPolicyResponse(
            expiryTime = javaType.expiryTime().map({ args0 -> args0 }).orElse(null),
            permission = javaType.permission().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
