@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Settings for Azure Files identity based authentication.
 * @property activeDirectoryProperties Required if directoryServiceOptions are AD, optional if they are AADKERB.
 * @property defaultSharePermission Default share permission for users using Kerberos authentication if RBAC role is not assigned.
 * @property directoryServiceOptions Indicates the directory service used. Note that this enum may be extended in the future.
 */
public data class AzureFilesIdentityBasedAuthenticationResponse(
    public val activeDirectoryProperties: ActiveDirectoryPropertiesResponse? = null,
    public val defaultSharePermission: String? = null,
    public val directoryServiceOptions: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.AzureFilesIdentityBasedAuthenticationResponse): AzureFilesIdentityBasedAuthenticationResponse =
            AzureFilesIdentityBasedAuthenticationResponse(
                activeDirectoryProperties = javaType.activeDirectoryProperties().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.storage.kotlin.outputs.ActiveDirectoryPropertiesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                defaultSharePermission = javaType.defaultSharePermission().map({ args0 -> args0 }).orElse(null),
                directoryServiceOptions = javaType.directoryServiceOptions(),
            )
    }
}
