@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An object that defines the blob inventory rule filter conditions. For 'Blob' definition.objectType all filter properties are applicable, 'blobTypes' is required and others are optional. For 'Container' definition.objectType only prefixMatch is applicable and is optional.
 * @property blobTypes An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support pageBlobs. This field is required when definition.objectType property is set to 'Blob'.
 * @property excludePrefix An array of strings with maximum 10 blob prefixes to be excluded from the inventory.
 * @property includeBlobVersions Includes blob versions in blob inventory when value is set to true. The definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this property is set to true, else they must be excluded.
 * @property includeDeleted For 'Container' definition.objectType the definition.schemaFields must include 'Deleted, Version, DeletedTime and RemainingRetentionDays'. For 'Blob' definition.objectType and HNS enabled storage accounts the definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and RemainingRetentionDays' and for Hns disabled accounts the definition.schemaFields must include 'Deleted and RemainingRetentionDays', else it must be excluded.
 * @property includeSnapshots Includes blob snapshots in blob inventory when value is set to true. The definition.schemaFields value 'Snapshot' is required if this property is set to true, else it must be excluded.
 * @property prefixMatch An array of strings with maximum 10 blob prefixes to be included in the inventory.
 */
public data class BlobInventoryPolicyFilterResponse(
    public val blobTypes: List<String>? = null,
    public val excludePrefix: List<String>? = null,
    public val includeBlobVersions: Boolean? = null,
    public val includeDeleted: Boolean? = null,
    public val includeSnapshots: Boolean? = null,
    public val prefixMatch: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.BlobInventoryPolicyFilterResponse): BlobInventoryPolicyFilterResponse = BlobInventoryPolicyFilterResponse(
            blobTypes = javaType.blobTypes().map({ args0 -> args0 }),
            excludePrefix = javaType.excludePrefix().map({ args0 -> args0 }),
            includeBlobVersions = javaType.includeBlobVersions().map({ args0 -> args0 }).orElse(null),
            includeDeleted = javaType.includeDeleted().map({ args0 -> args0 }).orElse(null),
            includeSnapshots = javaType.includeSnapshots().map({ args0 -> args0 }).orElse(null),
            prefixMatch = javaType.prefixMatch().map({ args0 -> args0 }),
        )
    }
}
