@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The storage account blob inventory policy rules.
 * @property destination Deprecated Property from API version 2021-04-01 onwards, the required destination container name must be specified at the rule level 'policy.rule.destination'
 * @property enabled Policy is enabled if set to true.
 * @property rules The storage account blob inventory policy rules. The rule is applied when it is enabled.
 * @property type The valid value is Inventory
 */
public data class BlobInventoryPolicySchemaResponse(
    public val destination: String,
    public val enabled: Boolean,
    public val rules: List<BlobInventoryPolicyRuleResponse>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.BlobInventoryPolicySchemaResponse): BlobInventoryPolicySchemaResponse = BlobInventoryPolicySchemaResponse(
            destination = javaType.destination(),
            enabled = javaType.enabled(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.BlobInventoryPolicyRuleResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
