@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Blob range
 * @property endRange Blob end range. This is exclusive. Empty means account end.
 * @property startRange Blob start range. This is inclusive. Empty means account start.
 */
public data class BlobRestoreRangeResponse(
    public val endRange: String,
    public val startRange: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.BlobRestoreRangeResponse): BlobRestoreRangeResponse = BlobRestoreRangeResponse(
            endRange = javaType.endRange(),
            startRange = javaType.startRange(),
        )
    }
}
