@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Blob restore status.
 * @property failureReason Failure reason when blob restore is failed.
 * @property parameters Blob restore request parameters.
 * @property restoreId Id for tracking blob restore request.
 * @property status The status of blob restore progress. Possible values are: - InProgress: Indicates that blob restore is ongoing. - Complete: Indicates that blob restore has been completed successfully. - Failed: Indicates that blob restore is failed.
 */
public data class BlobRestoreStatusResponse(
    public val failureReason: String,
    public val parameters: BlobRestoreParametersResponse,
    public val restoreId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.BlobRestoreStatusResponse): BlobRestoreStatusResponse = BlobRestoreStatusResponse(
            failureReason = javaType.failureReason(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.BlobRestoreParametersResponse.Companion.toKotlin(args0)
            }),
            restoreId = javaType.restoreId(),
            status = javaType.status(),
        )
    }
}
