@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * The service properties for soft delete.
 * @property allowPermanentDelete This property when set to true allows deletion of the soft deleted blob versions and snapshots. This property cannot be used blob restore policy. This property only applies to blob service and does not apply to containers or file share.
 * @property days Indicates the number of days that the deleted item should be retained. The minimum specified value can be 1 and the maximum value can be 365.
 * @property enabled Indicates whether DeleteRetentionPolicy is enabled.
 */
public data class DeleteRetentionPolicyResponse(
    public val allowPermanentDelete: Boolean? = null,
    public val days: Int? = null,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.DeleteRetentionPolicyResponse): DeleteRetentionPolicyResponse = DeleteRetentionPolicyResponse(
            allowPermanentDelete = javaType.allowPermanentDelete().map({ args0 -> args0 }).orElse(null),
            days = javaType.days().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
