@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The encryption settings on the storage account.
 * @property encryptionIdentity The identity to be used with service-side encryption at rest.
 * @property keySource The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
 * @property keyVaultProperties Properties provided by key vault.
 * @property requireInfrastructureEncryption A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
 * @property services List of services which support encryption.
 */
public data class EncryptionResponse(
    public val encryptionIdentity: EncryptionIdentityResponse? = null,
    public val keySource: String? = null,
    public val keyVaultProperties: KeyVaultPropertiesResponse? = null,
    public val requireInfrastructureEncryption: Boolean? = null,
    public val services: EncryptionServicesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.EncryptionResponse): EncryptionResponse = EncryptionResponse(
            encryptionIdentity = javaType.encryptionIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.EncryptionIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keySource = javaType.keySource().map({ args0 -> args0 }).orElse(null),
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            requireInfrastructureEncryption = javaType.requireInfrastructureEncryption().map({ args0 ->
                args0
            }).orElse(null),
            services = javaType.services().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.EncryptionServicesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
