@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A service that allows server-side encryption to be used.
 * @property enabled A boolean indicating whether or not the service encrypts the data as it is stored. Encryption at rest is enabled by default today and cannot be disabled.
 * @property keyType Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used.
 * @property lastEnabledTime Gets a rough estimate of the date/time when the encryption was last enabled by the user. Data is encrypted at rest by default today and cannot be disabled.
 */
public data class EncryptionServiceResponse(
    public val enabled: Boolean? = null,
    public val keyType: String? = null,
    public val lastEnabledTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.EncryptionServiceResponse): EncryptionServiceResponse = EncryptionServiceResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            keyType = javaType.keyType().map({ args0 -> args0 }).orElse(null),
            lastEnabledTime = javaType.lastEnabledTime(),
        )
    }
}
