@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Target helps provide filter parameters for the objects in the storage account and forms the execution context for the storage task
 * @property excludePrefix List of object prefixes to be excluded from task execution. If there is a conflict between include and exclude prefixes, the exclude prefix will be the determining factor
 * @property prefix Required list of object prefixes to be included for task execution
 */
public data class ExecutionTargetResponse(
    public val excludePrefix: List<String>? = null,
    public val prefix: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ExecutionTargetResponse): ExecutionTargetResponse = ExecutionTargetResponse(
            excludePrefix = javaType.excludePrefix().map({ args0 -> args0 }),
            prefix = javaType.prefix().map({ args0 -> args0 }),
        )
    }
}
