@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Execution trigger for storage task assignment
 * @property parameters The trigger parameters of the storage task assignment execution
 * @property type The trigger type of the storage task assignment execution
 */
public data class ExecutionTriggerResponse(
    public val parameters: TriggerParametersResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ExecutionTriggerResponse): ExecutionTriggerResponse = ExecutionTriggerResponse(
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.TriggerParametersResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
