@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The ImmutabilityPolicy property of a blob container, including Id, resource name, resource type, Etag.
 * @property allowProtectedAppendWrites This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API.
 * @property allowProtectedAppendWritesAll This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and 'allowProtectedAppendWritesAll' properties are mutually exclusive.
 * @property etag Resource Etag.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property immutabilityPeriodSinceCreationInDays The immutability period for the blobs in the container since the policy creation, in days.
 * @property name The name of the resource
 * @property state The ImmutabilityPolicy state of a blob container, possible values include: Locked and Unlocked.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetBlobContainerImmutabilityPolicyResult(
    public val allowProtectedAppendWrites: Boolean? = null,
    public val allowProtectedAppendWritesAll: Boolean? = null,
    public val etag: String,
    public val id: String,
    public val immutabilityPeriodSinceCreationInDays: Int? = null,
    public val name: String,
    public val state: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.GetBlobContainerImmutabilityPolicyResult): GetBlobContainerImmutabilityPolicyResult = GetBlobContainerImmutabilityPolicyResult(
            allowProtectedAppendWrites = javaType.allowProtectedAppendWrites().map({ args0 ->
                args0
            }).orElse(null),
            allowProtectedAppendWritesAll = javaType.allowProtectedAppendWritesAll().map({ args0 ->
                args0
            }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            immutabilityPeriodSinceCreationInDays = javaType.immutabilityPeriodSinceCreationInDays().map({ args0 ->
                args0
            }).orElse(null),
            name = javaType.name(),
            state = javaType.state(),
            type = javaType.type(),
        )
    }
}
