@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Properties of the blob container, including Id, resource name, resource type, Etag.
 * @property defaultEncryptionScope Default the container to use specified encryption scope for all writes.
 * @property deleted Indicates whether the blob container was deleted.
 * @property deletedTime Blob container deletion time.
 * @property denyEncryptionScopeOverride Block override of encryption scope from the container default.
 * @property enableNfsV3AllSquash Enable NFSv3 all squash on blob container.
 * @property enableNfsV3RootSquash Enable NFSv3 root squash on blob container.
 * @property etag Resource Etag.
 * @property hasImmutabilityPolicy The hasImmutabilityPolicy public property is set to true by SRP if ImmutabilityPolicy has been created for this container. The hasImmutabilityPolicy public property is set to false by SRP if ImmutabilityPolicy has not been created for this container.
 * @property hasLegalHold The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property immutabilityPolicy The ImmutabilityPolicy property of the container.
 * @property immutableStorageWithVersioning The object level immutability property of the container. The property is immutable and can only be set to true at the container creation time. Existing containers must undergo a migration process.
 * @property lastModifiedTime Returns the date and time the container was last modified.
 * @property leaseDuration Specifies whether the lease on a container is of infinite or fixed duration, only when the container is leased.
 * @property leaseState Lease state of the container.
 * @property leaseStatus The lease status of the container.
 * @property legalHold The LegalHold property of the container.
 * @property metadata A name-value pair to associate with the container as metadata.
 * @property name The name of the resource
 * @property publicAccess Specifies whether data in the container may be accessed publicly and the level of access.
 * @property remainingRetentionDays Remaining retention days for soft deleted blob container.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version The version of the deleted blob container.
 */
public data class GetBlobContainerResult(
    public val defaultEncryptionScope: String? = null,
    public val deleted: Boolean,
    public val deletedTime: String,
    public val denyEncryptionScopeOverride: Boolean? = null,
    public val enableNfsV3AllSquash: Boolean? = null,
    public val enableNfsV3RootSquash: Boolean? = null,
    public val etag: String,
    public val hasImmutabilityPolicy: Boolean,
    public val hasLegalHold: Boolean,
    public val id: String,
    public val immutabilityPolicy: ImmutabilityPolicyPropertiesResponse,
    public val immutableStorageWithVersioning: ImmutableStorageWithVersioningResponse? = null,
    public val lastModifiedTime: String,
    public val leaseDuration: String,
    public val leaseState: String,
    public val leaseStatus: String,
    public val legalHold: LegalHoldPropertiesResponse,
    public val metadata: Map<String, String>? = null,
    public val name: String,
    public val publicAccess: String? = null,
    public val remainingRetentionDays: Int,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.GetBlobContainerResult): GetBlobContainerResult = GetBlobContainerResult(
            defaultEncryptionScope = javaType.defaultEncryptionScope().map({ args0 -> args0 }).orElse(null),
            deleted = javaType.deleted(),
            deletedTime = javaType.deletedTime(),
            denyEncryptionScopeOverride = javaType.denyEncryptionScopeOverride().map({ args0 ->
                args0
            }).orElse(null),
            enableNfsV3AllSquash = javaType.enableNfsV3AllSquash().map({ args0 -> args0 }).orElse(null),
            enableNfsV3RootSquash = javaType.enableNfsV3RootSquash().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            hasImmutabilityPolicy = javaType.hasImmutabilityPolicy(),
            hasLegalHold = javaType.hasLegalHold(),
            id = javaType.id(),
            immutabilityPolicy = javaType.immutabilityPolicy().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.ImmutabilityPolicyPropertiesResponse.Companion.toKotlin(args0)
            }),
            immutableStorageWithVersioning = javaType.immutableStorageWithVersioning().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ImmutableStorageWithVersioningResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime(),
            leaseDuration = javaType.leaseDuration(),
            leaseState = javaType.leaseState(),
            leaseStatus = javaType.leaseStatus(),
            legalHold = javaType.legalHold().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.LegalHoldPropertiesResponse.Companion.toKotlin(args0)
            }),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            name = javaType.name(),
            publicAccess = javaType.publicAccess().map({ args0 -> args0 }).orElse(null),
            remainingRetentionDays = javaType.remainingRetentionDays(),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
