@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The storage account blob inventory policy.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastModifiedTime Returns the last modified date and time of the blob inventory policy.
 * @property name The name of the resource
 * @property policy The storage account blob inventory policy object. It is composed of policy rules.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetBlobInventoryPolicyResult(
    public val id: String,
    public val lastModifiedTime: String,
    public val name: String,
    public val policy: BlobInventoryPolicySchemaResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.GetBlobInventoryPolicyResult): GetBlobInventoryPolicyResult = GetBlobInventoryPolicyResult(
            id = javaType.id(),
            lastModifiedTime = javaType.lastModifiedTime(),
            name = javaType.name(),
            policy = javaType.policy().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.BlobInventoryPolicySchemaResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
