@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The Encryption Scope resource.
 * @property creationTime Gets the creation date and time of the encryption scope in UTC.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property keyVaultProperties The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
 * @property lastModifiedTime Gets the last modification date and time of the encryption scope in UTC.
 * @property name The name of the resource
 * @property requireInfrastructureEncryption A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
 * @property source The provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault.
 * @property state The state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetEncryptionScopeResult(
    public val creationTime: String,
    public val id: String,
    public val keyVaultProperties: EncryptionScopeKeyVaultPropertiesResponse? = null,
    public val lastModifiedTime: String,
    public val name: String,
    public val requireInfrastructureEncryption: Boolean? = null,
    public val source: String? = null,
    public val state: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.GetEncryptionScopeResult): GetEncryptionScopeResult = GetEncryptionScopeResult(
            creationTime = javaType.creationTime(),
            id = javaType.id(),
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.EncryptionScopeKeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime(),
            name = javaType.name(),
            requireInfrastructureEncryption = javaType.requireInfrastructureEncryption().map({ args0 ->
                args0
            }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
