@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Get Storage Account ManagementPolicies operation response.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastModifiedTime Returns the date and time the ManagementPolicies was last modified.
 * @property name The name of the resource
 * @property policy The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetManagementPolicyResult(
    public val id: String,
    public val lastModifiedTime: String,
    public val name: String,
    public val policy: ManagementPolicySchemaResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.GetManagementPolicyResult): GetManagementPolicyResult = GetManagementPolicyResult(
            id = javaType.id(),
            lastModifiedTime = javaType.lastModifiedTime(),
            name = javaType.name(),
            policy = javaType.policy().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.ManagementPolicySchemaResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
