@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The storage account.
 * @property accessTier Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier is the default value for premium block blobs storage account type and it cannot be changed for the premium block blobs storage account type.
 * @property allowBlobPublicAccess Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
 * @property allowCrossTenantReplication Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
 * @property allowSharedKeyAccess Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If false, then all requests, including shared access signatures, must be authorized with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
 * @property allowedCopyScope Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
 * @property azureFilesIdentityBasedAuthentication Provides the identity based authentication settings for Azure Files.
 * @property blobRestoreStatus Blob restore status
 * @property creationTime Gets the creation date and time of the storage account in UTC.
 * @property customDomain Gets the custom domain the user assigned to this storage account.
 * @property defaultToOAuthAuthentication A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false for this property.
 * @property dnsEndpointType Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier.
 * @property enableHttpsTrafficOnly Allows https traffic only to storage service if sets to true.
 * @property enableNfsV3 NFS 3.0 protocol support enabled if set to true.
 * @property encryption Encryption settings to be used for server-side encryption for the storage account.
 * @property extendedLocation The extendedLocation of the resource.
 * @property failoverInProgress If the failover is in progress, the value will be true, otherwise, it will be null.
 * @property geoReplicationStats Geo Replication Stats
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the resource.
 * @property immutableStorageWithVersioning The property is immutable and can only be set to true at the account creation time. When set to true, it enables object level immutability for all the containers in the account by default.
 * @property isHnsEnabled Account HierarchicalNamespace enabled if sets to true.
 * @property isLocalUserEnabled Enables local users feature, if set to true
 * @property isSftpEnabled Enables Secure File Transfer Protocol, if set to true
 * @property keyCreationTime Storage account keys creation time.
 * @property keyPolicy KeyPolicy assigned to the storage account.
 * @property kind Gets the Kind.
 * @property largeFileSharesState Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
 * @property lastGeoFailoverTime Gets the timestamp of the most recent instance of a failover to the secondary location. Only the most recent timestamp is retained. This element is not returned if there has never been a failover instance. Only available if the accountType is Standard_GRS or Standard_RAGRS.
 * @property location The geo-location where the resource lives
 * @property minimumTlsVersion Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
 * @property name The name of the resource
 * @property networkRuleSet Network rule set
 * @property primaryEndpoints Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object. Note that Standard_ZRS and Premium_LRS accounts only return the blob endpoint.
 * @property primaryLocation Gets the location of the primary data center for the storage account.
 * @property privateEndpointConnections List of private endpoint connection associated with the specified storage account
 * @property provisioningState Gets the status of the storage account at the time the operation was called.
 * @property publicNetworkAccess Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
 * @property routingPreference Maintains information about the network routing choice opted by the user for data transfer
 * @property sasPolicy SasPolicy assigned to the storage account.
 * @property secondaryEndpoints Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object from the secondary location of the storage account. Only available if the SKU name is Standard_RAGRS.
 * @property secondaryLocation Gets the location of the geo-replicated secondary for the storage account. Only available if the accountType is Standard_GRS or Standard_RAGRS.
 * @property sku Gets the SKU.
 * @property statusOfPrimary Gets the status indicating whether the primary location of the storage account is available or unavailable.
 * @property statusOfSecondary Gets the status indicating whether the secondary location of the storage account is available or unavailable. Only available if the SKU name is Standard_GRS or Standard_RAGRS.
 * @property storageAccountSkuConversionStatus This property is readOnly and is set by server during asynchronous storage account sku conversion operations.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetStorageAccountResult(
    public val accessTier: String,
    public val allowBlobPublicAccess: Boolean? = null,
    public val allowCrossTenantReplication: Boolean? = null,
    public val allowSharedKeyAccess: Boolean? = null,
    public val allowedCopyScope: String? = null,
    public val azureFilesIdentityBasedAuthentication: AzureFilesIdentityBasedAuthenticationResponse? =
        null,
    public val blobRestoreStatus: BlobRestoreStatusResponse,
    public val creationTime: String,
    public val customDomain: CustomDomainResponse,
    public val defaultToOAuthAuthentication: Boolean? = null,
    public val dnsEndpointType: String? = null,
    public val enableHttpsTrafficOnly: Boolean? = null,
    public val enableNfsV3: Boolean? = null,
    public val encryption: EncryptionResponse,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val failoverInProgress: Boolean,
    public val geoReplicationStats: GeoReplicationStatsResponse,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val immutableStorageWithVersioning: ImmutableStorageAccountResponse? = null,
    public val isHnsEnabled: Boolean? = null,
    public val isLocalUserEnabled: Boolean? = null,
    public val isSftpEnabled: Boolean? = null,
    public val keyCreationTime: KeyCreationTimeResponse,
    public val keyPolicy: KeyPolicyResponse,
    public val kind: String,
    public val largeFileSharesState: String? = null,
    public val lastGeoFailoverTime: String,
    public val location: String,
    public val minimumTlsVersion: String? = null,
    public val name: String,
    public val networkRuleSet: NetworkRuleSetResponse,
    public val primaryEndpoints: EndpointsResponse,
    public val primaryLocation: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val routingPreference: RoutingPreferenceResponse? = null,
    public val sasPolicy: SasPolicyResponse,
    public val secondaryEndpoints: EndpointsResponse,
    public val secondaryLocation: String,
    public val sku: SkuResponse,
    public val statusOfPrimary: String,
    public val statusOfSecondary: String,
    public val storageAccountSkuConversionStatus: StorageAccountSkuConversionStatusResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.GetStorageAccountResult): GetStorageAccountResult = GetStorageAccountResult(
            accessTier = javaType.accessTier(),
            allowBlobPublicAccess = javaType.allowBlobPublicAccess().map({ args0 -> args0 }).orElse(null),
            allowCrossTenantReplication = javaType.allowCrossTenantReplication().map({ args0 ->
                args0
            }).orElse(null),
            allowSharedKeyAccess = javaType.allowSharedKeyAccess().map({ args0 -> args0 }).orElse(null),
            allowedCopyScope = javaType.allowedCopyScope().map({ args0 -> args0 }).orElse(null),
            azureFilesIdentityBasedAuthentication = javaType.azureFilesIdentityBasedAuthentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.AzureFilesIdentityBasedAuthenticationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            blobRestoreStatus = javaType.blobRestoreStatus().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.BlobRestoreStatusResponse.Companion.toKotlin(args0)
            }),
            creationTime = javaType.creationTime(),
            customDomain = javaType.customDomain().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.CustomDomainResponse.Companion.toKotlin(args0)
            }),
            defaultToOAuthAuthentication = javaType.defaultToOAuthAuthentication().map({ args0 ->
                args0
            }).orElse(null),
            dnsEndpointType = javaType.dnsEndpointType().map({ args0 -> args0 }).orElse(null),
            enableHttpsTrafficOnly = javaType.enableHttpsTrafficOnly().map({ args0 -> args0 }).orElse(null),
            enableNfsV3 = javaType.enableNfsV3().map({ args0 -> args0 }).orElse(null),
            encryption = javaType.encryption().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.EncryptionResponse.Companion.toKotlin(args0)
            }),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            failoverInProgress = javaType.failoverInProgress(),
            geoReplicationStats = javaType.geoReplicationStats().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.GeoReplicationStatsResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            immutableStorageWithVersioning = javaType.immutableStorageWithVersioning().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ImmutableStorageAccountResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isHnsEnabled = javaType.isHnsEnabled().map({ args0 -> args0 }).orElse(null),
            isLocalUserEnabled = javaType.isLocalUserEnabled().map({ args0 -> args0 }).orElse(null),
            isSftpEnabled = javaType.isSftpEnabled().map({ args0 -> args0 }).orElse(null),
            keyCreationTime = javaType.keyCreationTime().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.KeyCreationTimeResponse.Companion.toKotlin(args0)
            }),
            keyPolicy = javaType.keyPolicy().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.KeyPolicyResponse.Companion.toKotlin(args0)
            }),
            kind = javaType.kind(),
            largeFileSharesState = javaType.largeFileSharesState().map({ args0 -> args0 }).orElse(null),
            lastGeoFailoverTime = javaType.lastGeoFailoverTime(),
            location = javaType.location(),
            minimumTlsVersion = javaType.minimumTlsVersion().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkRuleSet = javaType.networkRuleSet().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.NetworkRuleSetResponse.Companion.toKotlin(args0)
            }),
            primaryEndpoints = javaType.primaryEndpoints().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.EndpointsResponse.Companion.toKotlin(args0)
            }),
            primaryLocation = javaType.primaryLocation(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            routingPreference = javaType.routingPreference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.RoutingPreferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sasPolicy = javaType.sasPolicy().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.SasPolicyResponse.Companion.toKotlin(args0)
            }),
            secondaryEndpoints = javaType.secondaryEndpoints().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.EndpointsResponse.Companion.toKotlin(args0)
            }),
            secondaryLocation = javaType.secondaryLocation(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            statusOfPrimary = javaType.statusOfPrimary(),
            statusOfSecondary = javaType.statusOfSecondary(),
            storageAccountSkuConversionStatus = javaType.storageAccountSkuConversionStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.StorageAccountSkuConversionStatusResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
