@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of an ImmutabilityPolicy of a blob container.
 * @property allowProtectedAppendWrites This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API.
 * @property allowProtectedAppendWritesAll This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and 'allowProtectedAppendWritesAll' properties are mutually exclusive.
 * @property etag ImmutabilityPolicy Etag.
 * @property immutabilityPeriodSinceCreationInDays The immutability period for the blobs in the container since the policy creation, in days.
 * @property state The ImmutabilityPolicy state of a blob container, possible values include: Locked and Unlocked.
 * @property updateHistory The ImmutabilityPolicy update history of the blob container.
 */
public data class ImmutabilityPolicyPropertiesResponse(
    public val allowProtectedAppendWrites: Boolean? = null,
    public val allowProtectedAppendWritesAll: Boolean? = null,
    public val etag: String,
    public val immutabilityPeriodSinceCreationInDays: Int? = null,
    public val state: String,
    public val updateHistory: List<UpdateHistoryPropertyResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ImmutabilityPolicyPropertiesResponse): ImmutabilityPolicyPropertiesResponse = ImmutabilityPolicyPropertiesResponse(
            allowProtectedAppendWrites = javaType.allowProtectedAppendWrites().map({ args0 ->
                args0
            }).orElse(null),
            allowProtectedAppendWritesAll = javaType.allowProtectedAppendWritesAll().map({ args0 ->
                args0
            }).orElse(null),
            etag = javaType.etag(),
            immutabilityPeriodSinceCreationInDays = javaType.immutabilityPeriodSinceCreationInDays().map({ args0 ->
                args0
            }).orElse(null),
            state = javaType.state(),
            updateHistory = javaType.updateHistory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.UpdateHistoryPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
