@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Storage account keys creation time.
 * @property key1
 * @property key2
 */
public data class KeyCreationTimeResponse(
    public val key1: String? = null,
    public val key2: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.KeyCreationTimeResponse): KeyCreationTimeResponse = KeyCreationTimeResponse(
            key1 = javaType.key1().map({ args0 -> args0 }).orElse(null),
            key2 = javaType.key2().map({ args0 -> args0 }).orElse(null),
        )
    }
}
