@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Storage Account Local User keys.
 * @property sharedKey Auto generated by the server for SMB authentication.
 * @property sshAuthorizedKeys Optional, local user ssh authorized keys for SFTP.
 */
public data class ListLocalUserKeysResult(
    public val sharedKey: String,
    public val sshAuthorizedKeys: List<SshPublicKeyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ListLocalUserKeysResult): ListLocalUserKeysResult = ListLocalUserKeysResult(
            sharedKey = javaType.sharedKey(),
            sshAuthorizedKeys = javaType.sshAuthorizedKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.SshPublicKeyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
