@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Suppress

/**
 * Actions are applied to the filtered blobs when the execution condition is met.
 * @property baseBlob The management policy action for base blob
 * @property snapshot The management policy action for snapshot
 * @property version The management policy action for version
 */
public data class ManagementPolicyActionResponse(
    public val baseBlob: ManagementPolicyBaseBlobResponse? = null,
    public val snapshot: ManagementPolicySnapShotResponse? = null,
    public val version: ManagementPolicyVersionResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ManagementPolicyActionResponse): ManagementPolicyActionResponse = ManagementPolicyActionResponse(
            baseBlob = javaType.baseBlob().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ManagementPolicyBaseBlobResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            snapshot = javaType.snapshot().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ManagementPolicySnapShotResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            version = javaType.version().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ManagementPolicyVersionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
