@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Suppress

/**
 * An object that defines the Lifecycle rule. Each definition is made up with a filters set and an actions set.
 * @property actions An object that defines the action set.
 * @property filters An object that defines the filter set.
 */
public data class ManagementPolicyDefinitionResponse(
    public val actions: ManagementPolicyActionResponse,
    public val filters: ManagementPolicyFilterResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ManagementPolicyDefinitionResponse): ManagementPolicyDefinitionResponse = ManagementPolicyDefinitionResponse(
            actions = javaType.actions().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.ManagementPolicyActionResponse.Companion.toKotlin(args0)
            }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ManagementPolicyFilterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
