@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Filters limit rule actions to a subset of blobs within the storage account. If multiple filters are defined, a logical AND is performed on all filters.
 * @property blobIndexMatch An array of blob index tag based filters, there can be at most 10 tag filters
 * @property blobTypes An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
 * @property prefixMatch An array of strings for prefixes to be match.
 */
public data class ManagementPolicyFilterResponse(
    public val blobIndexMatch: List<TagFilterResponse>? = null,
    public val blobTypes: List<String>,
    public val prefixMatch: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ManagementPolicyFilterResponse): ManagementPolicyFilterResponse = ManagementPolicyFilterResponse(
            blobIndexMatch = javaType.blobIndexMatch().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.TagFilterResponse.Companion.toKotlin(args0)
                })
            }),
            blobTypes = javaType.blobTypes().map({ args0 -> args0 }),
            prefixMatch = javaType.prefixMatch().map({ args0 -> args0 }),
        )
    }
}
