@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
 * @property rules The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
 */
public data class ManagementPolicySchemaResponse(
    public val rules: List<ManagementPolicyRuleResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ManagementPolicySchemaResponse): ManagementPolicySchemaResponse = ManagementPolicySchemaResponse(
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ManagementPolicyRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
