@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Suppress

/**
 * Management policy action for blob version.
 * @property delete The function to delete the blob version
 * @property tierToArchive The function to tier blob version to archive storage.
 * @property tierToCold The function to tier blobs to cold storage.
 * @property tierToCool The function to tier blob version to cool storage.
 * @property tierToHot The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts
 */
public data class ManagementPolicyVersionResponse(
    public val delete: DateAfterCreationResponse? = null,
    public val tierToArchive: DateAfterCreationResponse? = null,
    public val tierToCold: DateAfterCreationResponse? = null,
    public val tierToCool: DateAfterCreationResponse? = null,
    public val tierToHot: DateAfterCreationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ManagementPolicyVersionResponse): ManagementPolicyVersionResponse = ManagementPolicyVersionResponse(
            delete = javaType.delete().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.DateAfterCreationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tierToArchive = javaType.tierToArchive().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.DateAfterCreationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tierToCold = javaType.tierToCold().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.DateAfterCreationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tierToCool = javaType.tierToCool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.DateAfterCreationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tierToHot = javaType.tierToHot().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.DateAfterCreationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
