@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of information about the state of the connection between service consumer and provider.
 * @property actionRequired A message indicating if changes on the service provider require any updates on the consumer.
 * @property description The reason for approval/rejection of the connection.
 * @property status Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
 */
public data class PrivateLinkServiceConnectionStateResponse(
    public val actionRequired: String? = null,
    public val description: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.PrivateLinkServiceConnectionStateResponse): PrivateLinkServiceConnectionStateResponse = PrivateLinkServiceConnectionStateResponse(
            actionRequired = javaType.actionRequired().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
