@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Routing preference defines the type of network, either microsoft or internet routing to be used to deliver the user data, the default option is microsoft routing
 * @property publishInternetEndpoints A boolean flag which indicates whether internet routing storage endpoints are to be published
 * @property publishMicrosoftEndpoints A boolean flag which indicates whether microsoft routing storage endpoints are to be published
 * @property routingChoice Routing Choice defines the kind of network routing opted by the user.
 */
public data class RoutingPreferenceResponse(
    public val publishInternetEndpoints: Boolean? = null,
    public val publishMicrosoftEndpoints: Boolean? = null,
    public val routingChoice: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.RoutingPreferenceResponse): RoutingPreferenceResponse = RoutingPreferenceResponse(
            publishInternetEndpoints = javaType.publishInternetEndpoints().map({ args0 -> args0 }).orElse(null),
            publishMicrosoftEndpoints = javaType.publishMicrosoftEndpoints().map({ args0 ->
                args0
            }).orElse(null),
            routingChoice = javaType.routingChoice().map({ args0 -> args0 }).orElse(null),
        )
    }
}
