@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SasPolicy assigned to the storage account.
 * @property expirationAction The SAS expiration action. Can only be Log.
 * @property sasExpirationPeriod The SAS expiration period, DD.HH:MM:SS.
 */
public data class SasPolicyResponse(
    public val expirationAction: String,
    public val sasExpirationPeriod: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.SasPolicyResponse): SasPolicyResponse = SasPolicyResponse(
            expirationAction = javaType.expirationAction(),
            sasExpirationPeriod = javaType.sasExpirationPeriod(),
        )
    }
}
