@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Setting for SMB protocol
 * @property authenticationMethods SMB authentication methods supported by server. Valid values are NTLMv2, Kerberos. Should be passed as a string with delimiter ';'.
 * @property channelEncryption SMB channel encryption supported by server. Valid values are AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as a string with delimiter ';'.
 * @property kerberosTicketEncryption Kerberos ticket encryption supported by server. Valid values are RC4-HMAC, AES-256. Should be passed as a string with delimiter ';'
 * @property multichannel Multichannel setting. Applies to Premium FileStorage only.
 * @property versions SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0, SMB3.1.1. Should be passed as a string with delimiter ';'.
 */
public data class SmbSettingResponse(
    public val authenticationMethods: String? = null,
    public val channelEncryption: String? = null,
    public val kerberosTicketEncryption: String? = null,
    public val multichannel: MultichannelResponse? = null,
    public val versions: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.SmbSettingResponse): SmbSettingResponse = SmbSettingResponse(
            authenticationMethods = javaType.authenticationMethods().map({ args0 -> args0 }).orElse(null),
            channelEncryption = javaType.channelEncryption().map({ args0 -> args0 }).orElse(null),
            kerberosTicketEncryption = javaType.kerberosTicketEncryption().map({ args0 -> args0 }).orElse(null),
            multichannel = javaType.multichannel().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.MultichannelResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            versions = javaType.versions().map({ args0 -> args0 }).orElse(null),
        )
    }
}
