@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Optional. It is used to store the function/usage of the key
 * @property key Ssh public key base64 encoded. The format should be: '<keyType> <keyData>', e.g. ssh-rsa AAAABBBB
 */
public data class SshPublicKeyResponse(
    public val description: String? = null,
    public val key: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.SshPublicKeyResponse): SshPublicKeyResponse = SshPublicKeyResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
        )
    }
}
