@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The URIs that are used to perform a retrieval of a public blob, file, web or dfs object via a internet routing endpoint.
 * @property blob Gets the blob endpoint.
 * @property dfs Gets the dfs endpoint.
 * @property file Gets the file endpoint.
 * @property web Gets the web endpoint.
 */
public data class StorageAccountInternetEndpointsResponse(
    public val blob: String,
    public val dfs: String,
    public val `file`: String,
    public val web: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.StorageAccountInternetEndpointsResponse): StorageAccountInternetEndpointsResponse = StorageAccountInternetEndpointsResponse(
            blob = javaType.blob(),
            dfs = javaType.dfs(),
            `file` = javaType.`file`(),
            web = javaType.web(),
        )
    }
}
