@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An access key for the storage account.
 * @property creationTime Creation time of the key, in round trip date format.
 * @property keyName Name of the key.
 * @property permissions Permissions for the key -- read-only or full permissions.
 * @property value Base 64-encoded value of the key.
 */
public data class StorageAccountKeyResponse(
    public val creationTime: String,
    public val keyName: String,
    public val permissions: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.StorageAccountKeyResponse): StorageAccountKeyResponse = StorageAccountKeyResponse(
            creationTime = javaType.creationTime(),
            keyName = javaType.keyName(),
            permissions = javaType.permissions(),
            `value` = javaType.`value`(),
        )
    }
}
