@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object via a microsoft routing endpoint.
 * @property blob Gets the blob endpoint.
 * @property dfs Gets the dfs endpoint.
 * @property file Gets the file endpoint.
 * @property queue Gets the queue endpoint.
 * @property table Gets the table endpoint.
 * @property web Gets the web endpoint.
 */
public data class StorageAccountMicrosoftEndpointsResponse(
    public val blob: String,
    public val dfs: String,
    public val `file`: String,
    public val queue: String,
    public val table: String,
    public val web: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.StorageAccountMicrosoftEndpointsResponse): StorageAccountMicrosoftEndpointsResponse = StorageAccountMicrosoftEndpointsResponse(
            blob = javaType.blob(),
            dfs = javaType.dfs(),
            `file` = javaType.`file`(),
            queue = javaType.queue(),
            table = javaType.table(),
            web = javaType.web(),
        )
    }
}
