@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * This defines the sku conversion status object for asynchronous sku conversions.
 * @property endTime This property represents the sku conversion end time.
 * @property skuConversionStatus This property indicates the current sku conversion status.
 * @property startTime This property represents the sku conversion start time.
 * @property targetSkuName This property represents the target sku name to which the account sku is being converted asynchronously.
 */
public data class StorageAccountSkuConversionStatusResponse(
    public val endTime: String,
    public val skuConversionStatus: String,
    public val startTime: String,
    public val targetSkuName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.StorageAccountSkuConversionStatusResponse): StorageAccountSkuConversionStatusResponse = StorageAccountSkuConversionStatusResponse(
            endTime = javaType.endTime(),
            skuConversionStatus = javaType.skuConversionStatus(),
            startTime = javaType.startTime(),
            targetSkuName = javaType.targetSkuName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
