@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Suppress

/**
 * Execution context of the storage task assignment.
 * @property target Execution target of the storage task assignment
 * @property trigger Execution trigger of the storage task assignment
 */
public data class StorageTaskAssignmentExecutionContextResponse(
    public val target: ExecutionTargetResponse,
    public val trigger: ExecutionTriggerResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.StorageTaskAssignmentExecutionContextResponse): StorageTaskAssignmentExecutionContextResponse =
            StorageTaskAssignmentExecutionContextResponse(
                target = javaType.target().let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ExecutionTargetResponse.Companion.toKotlin(args0)
                }),
                trigger = javaType.trigger().let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ExecutionTriggerResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
